//AnimalStuff
//Animal walks while moving forward, back, left, right, turning.
//Animal can talk

ENTITY * p_animal; //pointer to animal entity
SOUND * p_animal_talk = "jim.wav"; //pointer to animal speech

var talk_handle; //handle to talk sound file
//var talk_started; //toggle, if sound already started, don't restart it
var walk_speed;   //speed to animate walk bones
var talk_speed;	// speed to animate talking animal
var nod_speed;		// speed to nod animal head 
var shake_speed;	// speed to shake animal head

//animal speech/dialog/sound when it talks
function talk_sound()
{
	if(!snd_playing(talk_handle))// don't keep restarting sound while talk key_t pressed
  {
	talk_handle = snd_play(p_animal_talk,20,50); // change snd settings to suit
	
  }// end if
   
}

//animate the animal walking bones
function walk_anim()
{
	ent_animate(my, NULL, 0, 0); // reset all the animations
	walk_speed += 20 * time_step; // increase walk_speed; 1.5 sets the speed
  	ent_animate(my, "Walk", walk_speed, ANM_CYCLE); // animate the model (use "Walk")
}

//animate the animal talking bones
function talk_anim()
{
	ent_animate(my, NULL, 0, 0); // reset all the animations
	talk_speed += 20 * time_step; // increase walk_speed; 1.5 sets the speed
  	ent_animate(my, "Talk", talk_speed, ANM_CYCLE); // animate the model (use "Talk")
}

//animate the animal head nod bones
function nod_anim()
{
	ent_animate(my, NULL, 0, 0); // reset all the animations
	nod_speed += 20 * time_step; // increase walk_speed; 1.5 sets the speed
  	ent_animate(my, "Nod", nod_speed, ANM_CYCLE); // animate the model (use "Nod")
}

//animate the animal head shake bones
function shake_anim()
{
	ent_animate(my, NULL, 0, 0); // reset all the animations
	shake_speed += 20 * time_step; // increase walk_speed; 1.5 sets the speed
  	ent_animate(my, "Shake", shake_speed, ANM_CYCLE); // animate the model (use "Shake")
}

//use keyboard to move animal.
//move animal forward, back, left, right, and turn.
function move_animal()
{
	//use c_move for collison detection
	
	while(1)
	{
	
	if (key_w) 
	{
	 c_move(me,vector(3* time_step,0,0),nullvector,GLIDE);// forward
	 walk_anim();
	}
	
	if (key_s) 
	{
	  c_move(me,vector(-3* time_step,0,0),nullvector,GLIDE);//backward
	  walk_anim();
	}
	
	if (key_d)
	{
	 c_move(me,vector(0,-3* time_step,0),nullvector,GLIDE); //right
	 walk_anim();
 	}
 	
	if (key_a)
	{
	 c_move(me,vector(0,3* time_step,0),nullvector,GLIDE); //left
	 walk_anim();
 	}
 	
	if (key_z)c_move(me,vector(0,0,3* time_step),nullvector,GLIDE); //up
	if (key_c) c_move(me,vector(0,0,-3* time_step),nullvector,GLIDE); //down
	
	//pan, look around
	if (key_q) {my.pan += 2*time_step;walk_anim();}
	if (key_e) {my.pan -= 2*time_step;walk_anim();}
	
	wait(1);
	}
}//end function walk_animal

//use keyboard to play animal talk, nod head, shake head.
function play_animal()
{
	
	while(1)
	{
	
	if (key_t) 
	{
	 talk_anim();   // animal talk animation
	 talk_sound(); //play animal talk speech
	}
	else
	{
		
		snd_pause(talk_handle); // stop talk if no talk key
	}
	
	if (key_n) 
	{
	 nod_anim();
	}
	
	if (key_b)
	{
	 shake_anim();
 	}
 	
 		
	wait(1);
	}// end while
	
	if(!key_t)
 	snd_stop(talk_handle);//stop animal talk / speech / sound
}//end function play_animal

//action for animal that doesn't attack
action animal_nice()
{
	if(!player)
  {
   wait(1); //while player loads
  }
	
p_animal = me;
move_animal();
play_animal();

//add apparent gravity
while(1)
{
c_move(me,nullvector,vector(0,0,-2*time_step),GLIDE);
wait(1);
}

}

